Rem
Rem $Header: eginsert.sql 28-sep-98.10:21:42 jsharma Exp $
Rem
Rem eginsert.sql
Rem
Rem  Copyright (c) Oracle Corporation 1998. All Rights Reserved.
Rem
Rem    NAME
Rem      eginsert.sql - Example insertions
Rem
Rem    DESCRIPTION
Rem      Insert sample data into test81 tables which is assumed
Rem      to exist
Rem
Rem    NOTES
Rem      It is assumed a table named test81 exists
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsharma     08/02/99 - Add create index and query examples
Rem    jsharma     09/28/98 - Include the SRID field
Rem    jsharma     09/28/98 - Example code for SDO_GEOMETRY usage
Rem    jsharma     09/28/98 - Created
Rem

REM CREATE TABLE TEST81(GID NUMBER, GEOMETRY MDSYS.SDO_GEOMETRY);
REM It is assumed above table exists

REM It is also assumed that the view user_sdo_geom_metadata(
REM table_name varchar2(32), column_name varchar2(32), 
REM diminfo mdsys.sdo_dim_array) has the entry for TEST81
REM That is, the user has done a 
REM INSERT INTO USER_SDO_GEOM_METADATA VALUES('TEST81', 'GEOMETRY',
REM mdsys.sdo_dim_array(mdsys.sdo_dim_element('X', -100, 100, 0.005),
REM                     mdsys.sdo_dim_element('Y', -100, 100, 0.005)));

delete from test81 where gid between 1000 and 1013;

Rem Insert point clusters. The GType 5 should be used for this
INSERT INTO test81 VALUES (
  1000,
  mdsys.sdo_geometry(5, 
                     NULL, null,
                     mdsys.sdo_elem_info_array(1,1,3),
                     mdsys.sdo_ordinate_array(1.1, 1.1, 2.2, 2.2, 3.3, 4.4)));

INSERT INTO test81 VALUES (
  1001,
  mdsys.sdo_geometry(5, 
                     NULL, null,
                     mdsys.sdo_elem_info_array(1,1,2),
                     mdsys.sdo_ordinate_array(5, 6, 7, 8)));

Rem A simple polygon
INSERT INTO test81 VALUES (
  1002,
  mdsys.sdo_geometry(3, 
                     NULL, null,
                     mdsys.sdo_elem_info_array(1,3,1),
                     mdsys.sdo_ordinate_array(1, 1, 2, 2, 3, 3, 3, 1, 1, 1)));

Rem A polygon made up of circular arcs. Each triple of vertices make up an
Rem arc and the end-point of arc1 is the first point of arc2
Rem i.e. arc1= {(0,1), (1,0), (0,-1)} and arc2 = {(0,-1), (-1,0), (0,1)}
INSERT INTO test81 VALUES (
  1003,
  mdsys.sdo_geometry(3, 
                     NULL, null,
                     mdsys.sdo_elem_info_array(1,3,2),
                     mdsys.sdo_ordinate_array(0, 1, 1, 0, 0, -1, -1, 0, 0, 1)));

Rem A circle. (1,0), (0,1), (0,-1) are three points on the circumference
INSERT INTO test81 VALUES (
  1004,
  mdsys.sdo_geometry(3, 
                     NULL, null,
                     mdsys.sdo_elem_info_array(1,3,4),
                     mdsys.sdo_ordinate_array(1, 0, 0, 1, 0, -1)));

Rem A rectangle. (10,10) is the lower left corner and (20,20) the upper-right
INSERT INTO test81 VALUES (
  1005,
  mdsys.sdo_geometry(3, 
                     NULL, null,
                     mdsys.sdo_elem_info_array(1,3,3),
                     mdsys.sdo_ordinate_array(10, 10, 20, 20)));

Rem A geometry collection consisting of one compound line and one rectangle
INSERT INTO test81 VALUES (
  1006,
  mdsys.sdo_geometry(4, 
                     NULL, null,
                     mdsys.sdo_elem_info_array(1,4,2, 1,2,1, 7,2,2, 17,3,3),
                     mdsys.sdo_ordinate_array(50,50,
                                              50,30,
                                              10,30,
                                              10,50,
                                              20,60,
                                              30,50,
                                              40,60,
                                              50,50,
                                              25,35,
                                              35,40)));

Rem A compound polygon with a rectangular hole
INSERT INTO test81 VALUES (
  1007,
  mdsys.sdo_geometry(3, 
                     NULL, null,
                     mdsys.sdo_elem_info_array(1,5,2, 1,2,1, 7,2,2, 17,3,3),
                     mdsys.sdo_ordinate_array(50,50,
                                              50,30,
                                              10,30,
                                              10,50,
                                              20,60,
                                              30,50,
                                              40,60,
                                              50,50,
                                              25,35,
                                              35,40)));

INSERT INTO test81 VALUES (
  1008,
  mdsys.sdo_geometry(3, 
                     NULL, null,
                     mdsys.sdo_elem_info_array(1,3,1, 11,3,3),
                     mdsys.sdo_ordinate_array(50,50,
                                              50,30,
                                              10,30,
                                              10,50,
					      50,50,
                                              25,35,
                                              35,40)));


Rem This geometry will be ignored by the index creation routines
INSERT INTO test81 VALUES (
  1009,
  mdsys.sdo_geometry(0, 
                     NULL, null,
                     NULL, NULL));

Rem A NULL geometry
INSERT INTO test81 VALUES (1010, NULL);



INSERT INTO test81 VALUES (
  1011,
  mdsys.sdo_geometry(3,  null,
                     mdsys.sdo_point_type (12.5, 13.6, 14.7), 
                     mdsys.sdo_elem_info_array(1,3,1, 11,3,3),
                     mdsys.sdo_ordinate_array(50,50,
                                              50,30,
                                              10,30,
                                              10,50,
					      50,50,
                                              25,35,
                                              35,40)));

INSERT INTO test81 VALUES (
  1012,
  mdsys.sdo_geometry(3,  null,
                     mdsys.sdo_point_type (12.5, 13.6, NULL), 
                     mdsys.sdo_elem_info_array(1,3,1, 11,3,3),
                     mdsys.sdo_ordinate_array(50,50,
                                              50,30,
                                              10,30,
                                              10,50,
					      50,50,
                                              25,35,
                                              35,40)));



Rem Just a point geometry. This method can used to save storage if all
Rem geometries in a table are Points
INSERT INTO test81 VALUES (
  1013,
  mdsys.sdo_geometry(1,  null,
                     mdsys.sdo_point_type (12.5, 13.6, NULL), 
                     NULL, NULL));




commit ;

REM Create an index on this data

CREATE INDEX test_idx on test81(geometry) indextype is mdsys.spatial_index
parameters ('sdo_level=5 sdo_numtiles=6');


REM Perform some simple queries on this data

REM first an SDO_RELATE using a dynamic rectangular window with lower left
REM and upper right coordinates of {(1,1), (20,20)}
select gid from test81 where 
mdsys.sdo_relate(geometry, mdsys.sdo_geometry(3,null,null, 
                           mdsys.sdo_elem_info_array(1,3,3), 
                           mdsys.sdo_ordinate_array(1,1, 20, 20)), 
                 'MASK=ANYINTERACT QUERYTYPE=WINDOW') = 'TRUE' ;

REM Do the same with a circle of radius 10 around (0,0) 
select gid from test81 where 
mdsys.sdo_relate(geometry, mdsys.sdo_geometry(3,null,null, 
                           mdsys.sdo_elem_info_array(1,3,4), 
                           mdsys.sdo_ordinate_array(-10,0, 0, 10, 10, 0)), 
                 'MASK=ANYINTERACT QUERYTYPE=WINDOW') = 'TRUE' ;

REM and then an arbitrary line string {(10,10), (20, 20), (30, 30), (45,45)}
select gid from test81 where 
mdsys.sdo_relate(geometry, mdsys.sdo_geometry(2,null,null, 
                           mdsys.sdo_elem_info_array(1,2,1), 
                        mdsys.sdo_ordinate_array(10,10, 20,20, 30,30, 45,45)), 
                 'MASK=ANYINTERACT QUERYTYPE=WINDOW') = 'TRUE' ;

REM Do the same queries as above but use the index only, i.e. SDO_FILTER
REM to get the approximate answers that contain the real answers and some 
REM false hits

REM first an SDO_FILTER using a dynamic rectangular window with lower left
REM and upper right coordinates of {(1,1), (20,20)}
select gid from test81 where 
mdsys.sdo_filter(geometry, mdsys.sdo_geometry(3,null,null, 
                           mdsys.sdo_elem_info_array(1,3,3), 
                           mdsys.sdo_ordinate_array(1,1, 20, 20)), 
                 'QUERYTYPE=WINDOW') = 'TRUE' ;

REM Do the same with a circle of radius 10 around (0,0) 
select gid from test81 where 
mdsys.sdo_filter(geometry, mdsys.sdo_geometry(3,null,null, 
                           mdsys.sdo_elem_info_array(1,3,4), 
                           mdsys.sdo_ordinate_array(-10,0, 0, 10, 10, 0)), 
                 'QUERYTYPE=WINDOW') = 'TRUE' ;

REM and then an arbitrary line string {(10,10), (20, 20), (30, 30), (45,45)}
select gid from test81 where 
mdsys.sdo_filter(geometry, mdsys.sdo_geometry(2,null,null, 
                           mdsys.sdo_elem_info_array(1,2,1), 
                        mdsys.sdo_ordinate_array(10,10, 20,20, 30,30, 45,45)), 
                 'QUERYTYPE=WINDOW') = 'TRUE' ;


REM Do the same queries as above but use the sdo_within_distance operator
REM to get the geometries that lie within 10 Euclidean distance units
REM from the given ones

REM first an SDO_within_distance for a rectangular window with lower left
REM and upper right coordinates of {(1,1), (20,20)}
select gid from test81 where 
mdsys.sdo_within_distance(geometry, mdsys.sdo_geometry(3,null,null, 
                           mdsys.sdo_elem_info_array(1,3,3), 
                           mdsys.sdo_ordinate_array(1,1, 20, 20)), 
                 'DISTANCE=10 QUERYTYPE=WINDOW') = 'TRUE' ;

REM Do the same with a circle of radius 10 around (0,0) 
select gid from test81 where 
mdsys.sdo_within_distance(geometry, mdsys.sdo_geometry(3,null,null, 
                           mdsys.sdo_elem_info_array(1,3,4), 
                           mdsys.sdo_ordinate_array(-10,0, 0, 10, 10, 0)), 
                 'DISTANCE=10 QUERYTYPE=WINDOW') = 'TRUE' ;

REM and then an arbitrary line string {(10,10), (20, 20), (30, 30), (45,45)}
select gid from test81 where 
mdsys.sdo_within_distance(geometry, mdsys.sdo_geometry(2,null,null, 
                           mdsys.sdo_elem_info_array(1,2,1), 
                        mdsys.sdo_ordinate_array(10,10, 20,20, 30,30, 45,45)), 
                 'DISTANCE=10 QUERYTYPE=WINDOW') = 'TRUE' ;

